#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//chocolate swirl CommentedMod01.fsh  by   wnu  
//https://www.shadertoy.com/view/NtcSDs
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define AA 1.;

// Swirly function

float height(vec2 p){
    for(int i=1; i<10; i++){
        p.x+=.3/float(i)*sin(float(i)*4.*p.y+iTime*1.);
        p.y+=.3/float(i)*cos(float(i)*4.*p.x+iTime*1.);
    }
    
    float r = cos(p.x+p.y+1.)*.5+.5;
    
    return r/5.;
}

// Get normal from height function using derivatives

vec3 normal(vec2 p) {
  // Originally inspired by IQ from the source I copied this from.
  vec2 eps = -vec2(1.0/iResolution.y, 0.0);
  
  vec3 n;
  
  n.x = height(p + eps.xy) - height(p - eps.xy); //left height - right height
  n.y = height(p + eps.yx) - height(p - eps.yx); //down height - up height
  n.z = 2.0*eps.x;
  
  return normalize(n);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
    vec2 p = (fragCoord.xy/iResolution.xy- vec2(0.5))*2.0;
    p.x *= iResolution.x/iResolution.y;
    p *= 0.3;
    
    // Get height and normal
    
    
    
    float h = height(p);
    vec3 n = normal(p);
    
    #ifdef AA 
    vec3 r = vec3(1. / iResolution.xy, 0.);
    
    n = normal(p + r.xz);
    n += normal(p - r.xz);
    n += normal(p + r.zy);
    n += normal(p - r.zy);
    n /= 4.;
    #endif
    
    // Height augmented position
    
    vec3 ph = vec3(p.x,p.y,h);
    
    // Light position and direction from points to the light
    
    vec3 light = vec3(0.8,0.9,-0.9);
    vec3 ldir = normalize(light-ph);
    
    // Get shine based on angle of normal to light direction
    
    float shine = max(dot(ldir,n),0.);
    
    // Choose color, and create variable for the dark spots of the height function
    
    float fillDark = smoothstep(0.75,0.0,h*5.);
    vec3 chocolateColor = vec3(139.,69.,19.)/255.;
    
    // Base coloring
    
    vec3 col = chocolateColor +fillDark*vec3(2.,1.,1.);
    col *= h*5.;
    
    // Add 2 layers of exponentiated shine for highlights
    
    col += 0.5*pow(shine,8.);
    col += 0.1*pow(shine,2.);

    // Output to screen
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

